/*
 * structures for holding routes
 */

#define MAX_ROUTE_LEN 16

struct route {
 int length;
 char hops[MAX_ROUTE_LEN];
};

#define ROUTE_ENTRY(RP, LHOST, LPORT, RHOST, RPORT, INDEX)	\
  ((RP)->entries +						\
	(LHOST)*(RP)->lh_dim +					\
	(LPORT)*(RP)->lp_dim +					\
	(RHOST)*(RP)->rh_dim +					\
	(RPORT)*(RP)->rp_dim +					\
	(INDEX))

struct routefile {
  char *name;
  FILE *fp;

  /* these tell the size and layout of the entries array */
  int num_hosts;
  int num_ports;
  int routes_per_port;

  /* pre-computed dimensions */
  int lh_dim;
  int lp_dim;
  int rh_dim;
  int rp_dim;

  /* the array of route entries */
  struct route *entries;	
};
  
